#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <7Zip.au3>

;_GetChromiumZip()

if IsAdmin() = 0 Then
	MsgBox(0, "Check your privilege!", "This installer needs admin privileges. Try right clicking and choosing 'Run as administrator'")
	Exit
EndIf


Local $result

$result = FileInstall("C:\AUTOITDEV\7zip_testbed\resources\7-zip32.dll", "C:\AUTOITDEV\7zip_testbed\7-zip32.dll", 1)

$result = FileInstall("C:\AUTOITDEV\7zip_testbed\resources\7-zip64.dll", "C:\AUTOITDEV\7zip_testbed\7-zip64.dll", 1)


Global $install_dir = "C:\"



Global $hwnd_GUI = GUICreate("Chromium Installer", 256, 120, (@DesktopWidth / 2 - 128), ((@DesktopHeight / 2) - 128))
Global $lblLocation = GUICtrlCreateLabel('Choose where to create Chromium install folder.'  & @CRLF & '("\Chrome-Win32\" subfolder will be created.)', 4, 4, 248, 26)
Global $txtLocation = GUICtrlCreateInput($install_dir, 4,34, 200, 18)
Global $btnChangeLocation = GUICtrlCreateButton("Change", 206, 34, 44, 18)
Global $prgProgressBar = GUICtrlCreateProgress(4, 58, 248, 8)
Global $lblStatus = GUICtrlCreateLabel(" Click install to begin.", 4, 74, 200, 18, $SS_SUNKEN)
;GUICtrlSetState ($lblStatus, $GUI_DISABLE)
Global $btnINSTALL = GUICtrlCreateButton("Install", 206, 74 , 44, 18)

;Global $btnExtract = GUICtrlCreateButton("Extract", 4, 120, 44, 18)

Global $chkCreateShortcut = GUICtrlCreateCheckbox("Create desktop shortcut?", 48, 94,248, 26)
GUIctrlsetstate($chkCreateShortcut, $GUI_CHECKED)
GUISetState(@SW_SHOW, $hwnd_GUI)


;set to -1 after testing is complete.
Global $installer_size = 104396364


Main()




Func Main()

	Local $GUI_msg







	while 1
		$GUI_msg = GUIGetMsg()

		Switch $GUI_msg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $btnChangeLocation
				$install_dir = _GetInstallDir()
				if StringCompare("\", StringRight($install_dir, 1)) <> 0 Then
					consolewrite(@CRLF & "adding '\' to $install_dir: " & $install_dir)
					$install_dir = $install_dir & "\"

				EndIf

				GUICtrlSetData($txtLocation, $install_dir)
			case $btnINSTALL
				$install_dir = GUICtrlRead($txtLocation)
				if StringCompare("\", StringRight($install_dir, 1)) <> 0 Then
					consolewrite(@CRLF & "adding '\' to $install_dir: " & $install_dir)
					$install_dir = $install_dir & "\"
				EndIf


				if FileExists($install_dir) = 0 Then
					debuglog("did not find: " & $install_dir)

					MsgBox(0, "Invalid install location", "Install directory does not exist. Choose where to install Chromium.")
				Else
					_DisableControls()
					GUIctrlsetData($lblStatus,"Finding current version... patience...")
					_GetChromiumZip()
					GUIctrlsetData($lblStatus,"Extracting Chromium...")
					_CleanInstallDir()
					_ExtractChromiumArchive()
					_DoShortCut()

					if fileexists(@ScriptDir & "\7-zip32.dll") Then
						filedelete(@ScriptDir & "\7-zip32.dll")
					EndIf
					if fileexists(@ScriptDir & "\7-zip64.dll") Then
						filedelete(@ScriptDir & "\7-zip64.dll")
					EndIf
					if fileexists(@ScriptDir & "\chrome_install.zip") Then
						FileDelete(@ScriptDir & "\chrome_install.zip")
					EndIf
					MsgBox(0, "Success!", "Chromium installed. Enjoy!")
					Exit
				EndIf
			;case $btnExtract
			;	_DoShortCut()
		EndSwitch

	WEnd
EndFunc


Func _StringBetween2($s, $from, $to)
	$x = StringInStr($s, $from) + StringLen($from)
	$y = StringInStr(StringTrimLeft($s, $x), $to)
	Return StringMid($s, $x, $y)
EndFunc   ;==>_StringBetween2

Func DebugLog($string)
	ConsoleWrite(@CRLF & "DEBUGLOG: " & $string)

EndFunc

Func _DisableControls()
	GUICtrlSetState ($txtLocation, $GUI_DISABLE)
	GUICtrlSetState ($btnChangeLocation, $GUI_DISABLE)
	GUICtrlSetState ($btnINSTALL, $GUI_DISABLE)
	GUICtrlSetState ($chkCreateShortcut, $GUI_DISABLE)
EndFunc


Func _GetInstallDir()
	Local $chosen_path = FileSelectFolder("Choose location for Chrome installation folder.", "C:\", 7, $hwnd_GUI)

	if stringlen($chosen_path) > 0 Then
		Return $chosen_path
	Else
		Return -1
	EndIf


EndFunc

Func _GetChromiumZip()


	Local $temp_source = BinaryToString(InetRead('https://www.googleapis.com/storage/v1/b/chromium-browser-snapshots/o/Win%2FLAST_CHANGE'))
	;ConsoleWrite(@CRLF & "Temp source: " & $temp_source)

	Local $last_change_file = _StringBetween2($temp_source, '"mediaLink": "', '"')

	;DEBUGLOG( "most recent: " & $last_change_file)

	Local $last_change_num = InetRead($last_change_file)
	$last_change_num = BinaryToString($last_change_num)
	;DEBUGLOG("last change num: " & $last_change_num)

	Local $current_version_url = "https://commondatastorage.googleapis.com/chromium-browser-snapshots/index.html?prefix=Win/" & $last_change_num & "/"
	;DebugLog("current version url: " & $current_version_url)

	;Local $current_version_src = BinaryToString(InetRead($current_version_url))
	;DebugLog("current version src: " & $current_version_src)

	Local $chrome_zip_metadata_URL = "https://www.googleapis.com/storage/v1/b/chromium-browser-snapshots/o/Win%2F" & $last_change_num & "%2Fchrome-win32.zip"
	;Debuglog("METADATA URL: " & $chrome_zip_metadata_URL)

	$temp_source = BinaryToString(InetRead($chrome_zip_metadata_URL))
	$temp_source = _StringBetween2($temp_source, '"mediaLink": "', '"')

	;Debuglog("CHROME DOWNLOAD URL: " & $temp_source)

	If FileExists(@TempDir & "\chrome_install.zip") Then
		FileDelete(@TempDir & "\chrome_install.zip")
	EndIf


	$installer_size = InetGetSize($temp_source)


	;Debuglog("Chromium zip is " & (($installer_size / 1024) / 1024) & " megabytes.")

	;Debuglog("Chromium zip is " & $installer_size & " bytes.")
	;Exit

	;Debuglog("Downloading chromium zip...")
	HttpSetUserAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36")
	if FileExists(@ScriptDir & "\chrome_install.zip") Then
		filedelete(@ScriptDir & "\chrome_install.zip")
	EndIf

	if FileExists(@ScriptDir & "\chrome_install.zip") Then
		MsgBox(0, "Error", "Could not delete '" & @ScriptDir & "\chrome_install.zip'. Exiting.")
		Exit
	EndIf

	GUIctrlsetData($lblStatus,"Downloading Chromium...")

	Local $hdownload = InetGet($temp_source, @ScriptDir & "\chrome_install.zip", 1, 1)

	Local $download_complete = 0

	Local $dl_info = -1

	;Local $file_size = 104396364 ;we know this because we know this for debug purposes. in the final version we'll get it beforehand.

	Local $bytes_read = 0

	Local $progress = 0

	while $download_complete = 0
		$dl_info = InetGetInfo($hdownload, -1)

		$result = @error

		if $result <> 0 Then
			ConsoleWrite(@CRLF & "err:" & $result & " failed to get download info.")

			$download_complete = 1
		Else
			if $dl_info[2] = True Then
				$download_complete = 1
				GUICtrlSetData($prgProgressBar, 100)
			Else
				;download in progress
				$bytes_read = $dl_info[0]

				$progress = ($bytes_read / $installer_size) * 100
				GUICtrlSetData($prgProgressBar, $progress)
			EndIf
		EndIf



	WEnd

	InetClose($hdownload)
	;Debuglog("download complete.")
EndFunc


Func _ExtractChromiumArchive()
	if $installer_size <> -1 Then
		If FileExists(@ScriptDir & "\chrome_install.zip") Then
			;ConsoleWrite(@CRLF & "chrome install zip found.")
			$result = _7ZipStartup()
			;consolewrite(@CRLF & "_7ZipStartup() result: " & $result & "; error: " & @error)



			$result = _7ZipSetOwnerWindowEx($hwnd_GUI, "_ARCHIVERPROC")

			Local $err = @error

			;consolewrite(@CRLF & "_7ZipSetOwnerWindowEx() result: " & $result & "; error: " & $err)





			If $result = 0 Then Exit MsgBox(16, "_7ZipAdd demo", "Error occured:" & $err)

			Local $ArcFile = @ScriptDir & "\chrome_install.zip"

			;Local $out_dir = @ScriptDir & "\extract_test"



			if FileExists($ArcFile) = 0 Then Exit MsgBox(16, "_7ZipAdd demo", "input archive not found. Error")

			;$retResult = _7ZIPExtractEx($hGUI, $ArcFile, $out_dir, 1)

			$retResult = _7ZIPExtractEx($hwnd_GUI, $ArcFile, $install_dir, 1)

			_7ZipShutdown()

			GUIctrlsetData($lblStatus,"Installation complete.")
		EndIf

	EndIf
EndFunc

Func _CleanInstallDir()
	if fileexists($install_dir & "chrome-win32") Then
		;consolewrite(@CRLF & "install subdir exists. removing.")
		;Filedelete($install_dir & "chrome-win32")
		DirRemove($install_dir & "chrome-win32\",1)


	Else
		consolewrite(@CRLF & " install dir does not exist, so no need to remove it.")
	EndIf
EndFunc

Func _DoShortCut()
	If GUICtrlRead($chkCreateShortcut) = $GUI_CHECKED Then
		;ConsoleWrite(@CRLF & "we need to make a shortcut.")
		FileCreateShortcut($install_dir & "chrome-win32\chrome.exe", @DesktopDir & "\Chromium Browser.lnk", "", "", "Chromium Browser")
	EndIf
EndFunc

Func _ARCHIVERPROC($hWnd, $Msg, $nState, $ExInfo)
	Local $iFileSize, $iWriteSize, $iPercent = 0

	If $nState = 0 Then
		Local $EXTRACTINGINFO = DllStructCreate($tagEXTRACTINGINFO, $ExInfo)

		;GUICtrlSetData($ctlEdit, DllStructGetData($EXTRACTINGINFO, "szSourceFileName") & @CRLF, 1)

		$iFileSize = DllStructGetData($EXTRACTINGINFO, "dwFileSize")
		$iWriteSize = DllStructGetData($EXTRACTINGINFO, "dwWriteSize")

		$iPercent = Int($iWriteSize / $iFileSize * 100)

		GUICtrlSetData($prgProgressBar, $iPercent)
		Return 1
	EndIf

	If $nState = 2 Then GUICtrlSetData($prgProgressBar, 100)

	Return 1
EndFunc